;bij macro versie P16.14 M7.00

GRB = CDF(
			LENGTE(3)
           LIJNMODE(START_EINDE)
           RICHTING(RECHTS_POS)
		   )

; Afkortingen

S = GLOBALE_OPTIE(START)                    ; Afkorting voor de start van een lijn
E = GLOBALE_OPTIE(EINDE)                    ; Afkorting voor het einde van een lijn
B = GLOBALE_OPTIE(BOOG)                     ; Afkorting voor een boogpunt
L = GLOBALE_OPTIE(LOODRECHTE_LINKS)         ; Afkorting voor een dwarslijn naar links van een polylijn
R = GLOBALE_OPTIE(LOODRECHTE_RECHTS)        ; Afkorting voor een dwarslijn naar rechts van een polylijn
C = GLOBALE_OPTIE(SLUITEN)                  ; Afkorting voor het sluiten van een polylijn
X = GLOBALE_OPTIE(SYMBOOLRICHTING)          ; Afkorting voor een punt dat de richting van symbool aangeeft. (Punt)

* = UITGEBREIDE_OPTIE(PARALLELE_LIJN )      ; Geen afkorting voor parallelle lijnen
T = UITGEBREIDE_OPTIE(TEKST)                ; Afkorting voor tekst
W = UITGEBREIDE_OPTIE(BREEDTE)              ; Afkorting voor breedte
V = UITGEBREIDE_OPTIE(EXCENTRISCH(IN_VERLENGDE))     
                                            ; Afkorting voor in het verlengde
L = UITGEBREIDE_OPTIE(EXCENTRISCH(LOODRECHTE_LINKS))       
R = UITGEBREIDE_OPTIE(EXCENTRISCH(LOODRECHTE_RECHTS))       
                                            ; Afkortingen voor excentrische en onzichtbare punten links en rechts
/ = GLOBALE_OPTIE(CODE_SEPARATOR)           ; Teken dat de scheiding tussen 2 codes in n meting aangeeft.


* = PUNT (
		STIJL(0, 1)
		KLEUR(ROOD)
		LAAG("Velddata")
		)

;============================================================================
; BASIS
;============================================================================

; probleemzone
ANO = POLYLIJN  (
                LAAG("ANO")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(140)
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
				TEKST (
					LAAG("ANT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(140)
					POSITIE(0,0)
					INHOUD("%T")
					)
                )

;tekstcode voor spoorbaan en terrein
BBT = TEKST(
				LAAG("BBT")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(7)
				)	

; gebouwaanhorigheid type verdieping
GB1 = POLYLIJN  (
                LAAG("GBA1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(171)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )


; afdak
GB2 = POLYLIJN  (
                LAAG("GBA2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(163)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; gebouwaanhorigheid type loopbrug
GB3 = POLYLIJN  (
                LAAG("GBA3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(165)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; gebouwaanhorigheid type trap
GB4 = POLYLIJN  (
                LAAG("GBA4")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(185)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; gebouwaanhorigheid type zichtbare onderkeldering
GB5 = POLYLIJN  (
                LAAG("GBA5")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(141)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; rand gebouwaanhorigheid type ingezonken garagetoegang
GB6 = POLYLIJN  (
                LAAG("GBA6")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(143)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )


; gebouwaanhorigheid type verheven garagetoegang
GBE = POLYLIJN  (
                LAAG("GBA11")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(172)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; skeletzone
GRZ = POLYLIJN  (
                LAAG("GRZ3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(132)
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; terrestrisch gemeten gevel van gebouw
GV1 = POLYLIJN  (
                LAAG("GVL1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(210)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; constructiegevel van gebouw
GV6 = POLYLIJN  (
                LAAG("GVL6")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(11)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; niet-duurzame aanzet van gemene gevel
GV7 = POLYLIJN  (
                LAAG("GVL7")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(113)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; fictieve gevel van gebouw
GV9 = POLYLIJN  (
                LAAG("GVL9")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(21)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; terrestrisch gemeten gevelstuk van gebouw
GV0 = POLYLIJN  (
                LAAG("GVL10")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(171)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; virtuele huisnummers zichtbare gebouwen
HN1 = PUNT(
			LAAG("HNR")
			STIJL("GRB","HNR01")
			KLEUR(191)
			TEKST(
				LAAG("HNR")
				HORIZONTALE_ALIGNERING(MIDDEN) 
				VERTIKALE_ALIGNERING(MIDDEN)
				GROOTTE(11)
				KLEUR(11)
				POSITIE(0,0)
				INHOUD("%T")				
				)
        )
                
; virtuele huisnummers niet-zichtbare gebouwen
HN2 = PUNT(
			LAAG("HNR")
			STIJL("GRB","HNR02")
			KLEUR(191)
			TEKST(
				LAAG("HNR")
				HORIZONTALE_ALIGNERING(MIDDEN) 
				VERTIKALE_ALIGNERING(MIDDEN)
				GROOTTE(11)
				KLEUR(11)
				POSITIE(0,0)
				INHOUD("%T")				
				)				
         )

; overbrugging
K01 = POLYLIJN  (
                LAAG("KNW1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(77)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; waterbouwkundige constructie
K02 = POLYLIJN  (
                LAAG("KNW2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(62)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; cultuurhistorisch monument
K03 = POLYLIJN  (
                LAAG("KNW3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(34)
                GROEP("MONUMENTEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
				
; hoogspanningsmast / TV-mast
K04 = POLYLIJN  (
                LAAG("KNW4")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(15)
                GROEP("MASTEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; pijler
K05 = POLYLIJN  (
                LAAG("KNW5")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(22)
                GROEP("MASTEN")
                PUNT(
                        LAAG("ZPT
                        ")STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; rooster
K06 = POLYLIJN  (

                LAAG("KNW6")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(206)
                GROEP("ROOSTER")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; schoorsteen
K07 = POLYLIJN  (
                LAAG("KNW7")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(55)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
; koeltoren
K08 = POLYLIJN  (
                LAAG("KNW8")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(65)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; silo, opslagtank
K09 = POLYLIJN  (
                LAAG("KNW9")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(75)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; cabine
K10 = POLYLIJN  (
                LAAG("KNW10")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(114)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; watertoren
K11 = POLYLIJN  (
                LAAG("KNW11")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(160)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; tunnelmond
K12 = POLYLIJN  (
                LAAG("KNW12")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(245)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; chemische installatie
K13 = POLYLIJN  (
                LAAG("KNW13")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(33)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; nutspaal
K14 = POLYLIJN  (
                LAAG("KNW14")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(241)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; strandhoofd/lage havendam
K22 = POLYLIJN  (
                LAAG("KNW22")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(40)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; havendam
K23 = POLYLIJN  (
                LAAG("KNW23")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(150)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; staketsel
K24 = POLYLIJN  (
                LAAG("KNW24")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(21)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; zichtbare grenspaal
PR1 = PUNT      (
                LAAG("PRP1")
                STIJL("GRB","PRP101")
                KLEUR(225)
                )

; spoorbaan
SBN = POLYLIJN  (
                LAAG("SBN")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(150)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                TEKST (
					LAAG("BBT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					POSITIE(0,0)
					INHOUD("%T")
					)					
                )

				
; rand van terrein
TRN = POLYLIJN  (
                LAAG("TRN")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(7)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                TEKST (
					LAAG("BBT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					POSITIE(0,0)
					INHOUD("%T")
					)					
                )


; rand van de wegbaan
WB1 = POLYLIJN  (
                LAAG("WBN1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(16)
                GROEP("WEGRAND")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )


; rand van de wegbaan
WB2 = POLYLIJN  (
                LAAG("WBN2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(16)
                GROEP("WEGRAND")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )


; grens circulatiezone zwakke weggebruikers
WCZ = POLYLIJN  (  
				LAAG("WCZ")
				
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(192)
                		GROEP("DIVERSE")
				PUNT(  
					  LAAG("ZPT")
					  STIJL(0,0)
					  KLEUR(7)
					  )
				)


; bushok
WA1 = POLYLIJN  (
                LAAG("WGA1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(40)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
				
; overdekte fietsenstalling
WA3 = POLYLIJN  (
                LAAG("WGA3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(212)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				
				
; bergplaats
WA5 = POLYLIJN  (
                LAAG("WGA5")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(20)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
				
; as van de waterloop of gracht
WGR = POLYLIJN  (   
				LAAG("WGR")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(5)
                		GROEP("DIVERSE")
				PUNT( 
					   LAAG("ZPT")
					   STIJL(0,0)
					   KLEUR(7)
					   )
				)				

; wegknoop
WK1 = PUNT      (
                LAAG("WKN")
                STIJL("GRB","WKN01")
                KLEUR(43)
                )

; wegknoop
WK2 = PUNT      (
                LAAG("WKN")
                STIJL("GRB","WKN02")
                KLEUR(43)
                )

; wegknoop
WK3 = PUNT      (
                LAAG("WKN")
                STIJL("GRB","WKN03")
                KLEUR(43)
                )

; wegknoop
WK4 = PUNT      (
                LAAG("WKN")
                STIJL("GRB","WKN04")
                KLEUR(43)
                )

; wegknoop
WK5 = PUNT      (
                LAAG("WKN")
                STIJL("GRB","WKN05")
                KLEUR(43)
                )

; verhoogde boordsteen / kantsteen
WL1 = POLYLIJN  ( 
				LAAG("WLI1")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(31)
                GROEP("WEGEN")
				PUNT(
						LAAG("ZPT")
						STIJL(0,0)
						KLEUR(7)
						)
				)
               
; muur / stootband
WL2 = POLYLIJN  ( 
				LAAG("WLI2")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(41)
                GROEP("DIVERSE")
				PUNT(  
					  LAAG("ZPT")
					  STIJL(0,0)
					  KLEUR(7)
					  )
				)
               
; vangrail
WL3 = POLYLIJN  ( 
				LAAG("WLI3")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(11)
                GROEP("DIVERSE")
				PUNT(
						LAAG("ZPT")
						STIJL(0,0)
						KLEUR(7)
						)
				)

; niet-afgeboorde verhoging
WL9 = POLYLIJN  ( 
				LAAG("WLI9")
				
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(234)
                GROEP("DIVERSE")
				PUNT( 
					   LAAG("ZPT")
					   STIJL(0,0)
					   KLEUR(7)
					   )
				)
               
; grens onverharde zone
WOZ = POLYLIJN  (  
				LAAG("WOZ")
				
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(90)
                GROEP("WEGEN_WOZ")
				PUNT( 
					   LAAG("ZPT")
					   STIJL(0,0)
					   KLEUR(7)
					   )
				)

; paal  (basis)
P01 = PUNT(
			LAAG("WPI1")
			STIJL("GRB","WPI101")
			KLEUR(30)
			)		

; meerpaal (basis)
P30 = PUNT      (
                LAAG("WPI3")
                STIJL("GRB","WPI301")
                KLEUR(40)
                )
                
; bovengrondse brandkraan (basis)
P40 = PUNT      (
                LAAG("WPI4")
                STIJL("GRB","WPI401")
                KLEUR(10)
                )
                
; grenspaal (basis)
P50 = PUNT      (
                LAAG("WPI5")
                STIJL("GRB","WPI501")
                KLEUR(252)
                )

; rand van de rijbaan
WRB = POLYLIJN  (
                LAAG("WRB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(175)
                GROEP("WEGEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; zichtbaar cirkelvormig putdeksel (basis)
R01 = PUNT(
                LAAG("WRI1")
                STIJL("GRB","WRI101")
                KLEUR(220)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")		;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )
				
; zichtbare vierkant putdeksel (basis)
R02 = PUNT      (
                LAAG("WRI2")
                STIJL("GRB","WRI201")
                KLEUR(245)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")	;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )	
				
				
; spoorrail
WRL = POLYLIJN  (
                LAAG("WRL")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(16)
                GROEP("DIVERSE")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )				


; verhoogde verkeersdrempel
TI1 = POLYLIJN  (
                LAAG("WTI1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(222)
                GROEP("DIVERSE")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )
                
; verlaging in de verharde wegbaan
TI2 = POLYLIJN  (
                LAAG("WTI2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(202)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; watergang
WTZ = POLYLIJN  ( 
				LAAG("WTZ")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(161)
                GROEP("DIVERSE")
				PUNT( 
					   LAAG("ZPT")
					   STIJL(0,0)
					   KLEUR(7)
					   )
				)
				
				
; wegverbinding
WVB = POLYLIJN  (
                LAAG("WVB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(43)
                GROEP("WVB")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				
				
; opmetingshoogtepunt
ZPT = PUNT      (
                LAAG("ZPT")
                STIJL(0,0)
                KLEUR(7)
                )
				
				
				
;============================================================================
; DETAIL
;============================================================================				



; afsluitingen
AFS = POLYLIJN  (
                LAAG("AFS")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(233)
                GROEP("AFSLUITINGEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
				
; haag
AHG = POLYLIJN  (
                LAAG("AHG")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(114)
                GROEP("AFSLUITINGEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; muren
AMR = POLYLIJN  (
                LAAG("AMR")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(10)
                GROEP("MUUR")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; weideafsluitingen
AWD = POLYLIJN  (
                LAAG("AWD")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(205)
                GROEP("AFSLUITINGEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )			
				

                
; gebouwaanhorigheid type keldergat
GB8 = POLYLIJN  (
                LAAG("GBA8")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(190)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				

; rand gebouwaanhorigheid type keldergat
GB = PUNT_IN_POLYLIJN      
                (
                LAAG("1")
                OPTIE(TEKST)
                STIJL("GRB","GBA801")
                KLEUR(190)
                GROEP("GEBOUWEN")
                PROJECTIE
                TEKST   (
                        LAAG("THG")
                        DIKTE(LICHT)
                        GROOTTE(5)
                        HORIZONTALE_ALIGNERING(MIDDEN)
                        VERTIKALE_ALIGNERING(MIDDEN)
                        KLEUR(7)
                        INHOUD("%H")		;moet afgerond worden tot op cm: voorkeuren moeten goed staan
                        SCHUINE_TEKST
                        POSITIE(0, 0)
                        )
                )
				
; bouwsel
GBS = POLYLIJN  (
                LAAG("GBS")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(20)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				
				
				
				
; gebouw dorpelpeil
GD1 = PUNT  
                (
                LAAG("GDP1")
                STIJL("GRB","GDP101")
                KLEUR(8)
                TEKST   (
                        LAAG("THG")
                        GROOTTE(5)
                        HORIZONTALE_ALIGNERING(MIDDEN)
                        VERTIKALE_ALIGNERING(MIDDEN)
                        KLEUR(7)
                        INHOUD("%H")
                        SCHUINE_TEKST
                        POSITIE(0, 0)
                        )
                )				

; garage dorpelpeil
GD2 = PUNT      
                (
                LAAG("GDP2")
                STIJL("GRB","GDP201")
                KLEUR(173)
                TEKST   (
                        LAAG("THG")
                        GROOTTE(5)
                        HORIZONTALE_ALIGNERING(MIDDEN)
                        VERTIKALE_ALIGNERING(MIDDEN)
                        KLEUR(7)
                        INHOUD("%H")
                        SCHUINE_TEKST
                        POSITIE(0, 0)
                        )
                )
				
				
; rand gebouwfundament
GFD = POLYLIJN  (
                LAAG("GFD")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(46)
                GROEP("GEBOUWEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				

;hoogtepunt maaiveld
HOM = PUNT(
				LAAG("HOP")
				STIJL("GRB","HOP02")
				KLEUR(7)
				TEKST   (
					LAAG("THG")
					DIKTE(LICHT)
					GROOTTE(5)
					HORIZONTALE_ALIGNERING(MIDDEN)
					VERTIKALE_ALIGNERING(MIDDEN)
					KLEUR(7)
					INHOUD("%H")		;moet afgerond worden tot op cm: voorkeuren moeten goed staan
					SCHUINE_TEKST
					POSITIE(0, 0)
					)	
		)
				
;hoogtepunt constructie
HOC = PUNT(
				LAAG("HOP")
				STIJL("GRB","HOP03")
				KLEUR(7)
				TEKST   (
					LAAG("THG")
					DIKTE(LICHT)
					GROOTTE(5)
					HORIZONTALE_ALIGNERING(MIDDEN)
					VERTIKALE_ALIGNERING(MIDDEN)
					KLEUR(7)
					INHOUD("%H")		;moet afgerond worden tot op cm: voorkeuren moeten goed staan
					SCHUINE_TEKST
					POSITIE(0, 0)
					)	
		)				
				
;hoogtepunt buis bovenkant
HOB = PUNT(
				LAAG("HOP")
				STIJL("GRB","HOP04")
				KLEUR(7)
				TEKST   (
					LAAG("THG")
					DIKTE(LICHT)
					GROOTTE(5)
					HORIZONTALE_ALIGNERING(MIDDEN)
					VERTIKALE_ALIGNERING(MIDDEN)
					KLEUR(7)
					INHOUD("%H")		;moet afgerond worden tot op cm: voorkeuren moeten goed staan
					SCHUINE_TEKST
					POSITIE(0, 0)
					)	
		)				


; communicatiemast divers
K15 = POLYLIJN  (
                LAAG("KNW15")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(57)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; zichtbaar fundament of sokkel
K17 = POLYLIJN  (
                LAAG("KNW17")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(67)
                GROEP("DIVERSE2")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
; zichtbaar deksel of luik
K18 = POLYLIJN  (
                LAAG("KNW18")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(175)
                GROEP("DIVERSE3")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; kopmuur
K19 = POLYLIJN  (
                LAAG("KNW19")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(14)
                GROEP("DIVERSE4")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
						KLEUR(7)
                        )
                )
				
; trap tussen 2 straatniveaus
K25 = POLYLIJN  (
                LAAG("KNW25")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(203)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

K26 = POLYLIJN  (
                LAAG("KNW26")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(203)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

K27 = POLYLIJN  (
                LAAG("KNW27")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(203)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
				
; verdichtingspunten FVP1
MK1 = PUNT      (
                LAAG("MKV1")
                STIJL("GRB","MKV101")
                KLEUR(7)
				TEKST(
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%I")
					HORIZONTAL
					)
                )

; verdichtingspunten FVP2
MK2 = PUNT      (
                LAAG("MKV2")
                STIJL("GRB","MKV201")
                KLEUR(253)
				TEKST(
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%I")
					HORIZONTAL
					)
                )				
				
; perceelsreconstructiepunt
PR2 = PUNT      (
                LAAG("PRP2")
                STIJL("GRB","PRP201")
                KLEUR(160)
                )
                
; hoekpunt van weideafsluiting
PR3 = PUNT      (
                LAAG("PRP3")
                STIJL("GRB","PRP301")
                KLEUR(103)
                )				

;tekst hoogte
THG = TEKST(
				LAAG("THG")
				GROOTTE(5)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(7)
				)	
				
; Benzinepomp
WBP = PUNT      (
                LAAG("WBP")
                STIJL("GRB","WBP01")
                KLEUR(240)
                )				
				
; functiecode terreinobject
WFT = POLYLIJN  (
                LAAG("WFT")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(7)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
; openbaar toilet
WA6 = POLYLIJN  (
                LAAG("WGA6")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(50)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; boom met hoge stam
WI1 = POLYLIJN  (  
				LAAG("WGI1")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(102)
                GROEP("DIVERSE")
				PUNT(
						LAAG("ZPT")
						STIJL(0,0)
						KLEUR(7)
						)
				)
				
; boom met hoge stam
WG1 = PUNT(
				LAAG("WGI1")
				STIJL("GRB","WGI101")
				KLEUR(102)
				TEKST (											; functiecode boom, bestek optie groen- en begraafplaatsen
						LAAG("WGC")
						HORIZONTALE_ALIGNERING(MIDDEN) 
						VERTIKALE_ALIGNERING(MIDDEN)
						GROOTTE(7)
						KLEUR(10)
						POSITIE(0,0)
						INHOUD("%T")				; N = naaldboom, F = fruitboom, L = loofboom
						)	
				)
				
              
; boom met lage stam
WI2 = POLYLIJN  (

                LAAG("WGI2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(104)
                GROEP("DIVERSE")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )

                )
				
; boom met lage stam				
WP2 = PUNT(
			LAAG("WGI2")
			STIJL("GRB","WGI201")
			KLEUR(104)
			TEKST (											; functiecode boom, bestek optie groen- en begraafplaatsen
					LAAG("WGC")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(7)
					KLEUR(10)
					POSITIE(0,0)
					INHOUD("%T")				;N = naaldboom, F = fruitboom, L = loofboom
					)	
			)				
								
; groep groenelementen
WI5 = POLYLIJN  (   
				LAAG("WGI5")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(104)
                GROEP("DIVERSE")
				PUNT(   
					 LAAG("ZPT")
					 STIJL(0,0)
					 KLEUR(7)
					 )
				)				

; verharde rand van de watergang
GL1 = POLYLIJN  (  
				LAAG("WGL1")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(161)
                GROEP("DIVERSE")
				PUNT(  
					  LAAG("ZPT")
					  STIJL(0,0)
					  KLEUR(7)
					  )
				)
              
; onverharde rand van de watergang
WG3 = POLYLIJN  ( 
				LAAG("WGL3")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(123)
                GROEP("DIVERSE")
				PUNT(
						LAAG("ZPT")
						STIJL(0,0)
						KLEUR(7)
						)
               )
				
; nutskast
WK = PUNT      (
                LAAG("WKI")
                STIJL("GRB","WKI01")
                KLEUR(152)
				TEKST(
						INHOUD("%T")			;W,L,G,E,R,T,H,D
						LAAG("WNC")
						GROOTTE(7)
						HORIZONTALE_ALIGNERING(MIDDEN)
						VERTIKALE_ALIGNERING(MIDDEN)
						POSITIE(0,0)
						KLEUR(160)
					)
                )


; geconstrueerde rand onverharde weg / rijspoor
WL7 = POLYLIJN  ( 
				LAAG("WLI7")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(23)
                GROEP("DIVERSE")
				PUNT(  
					  LAAG("ZPT")
					  STIJL(0,0)
					  KLEUR(7)
					  )
				)
				
; borstwering
WL8 = POLYLIJN  (
                LAAG("WLI8")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(214)
                GROEP("DIVERSE")
                PUNT(     
					 LAAG("ZPT")
					 STIJL(0,0)
					 KLEUR(7)
					 )
                )
				
; muur binnen de wegbaan
L10 = POLYLIJN  (

                LAAG("WLI10")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(200)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; stootband type dupuis
L11 = POLYLIJN  (
                LAAG("WLI11")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(184)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
                
; stootband type new jersey
L12 = POLYLIJN  (
                LAAG("WLI12")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(190)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				
; stootband type veiligheidsband
L13 = POLYLIJN  ( 
				LAAG("WLI13")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(182)
                GROEP("DIVERSE")
				PUNT(   
					 LAAG("ZPT")
					 STIJL(0,0)
					 KLEUR(7)
					 )
				)
				
; stootband type biggetjes/varkensruggen
L14 = POLYLIJN  (      
				LAAG("WLI14")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(162)
                GROEP("DIVERSE")
				PUNT( 
					   LAAG("ZPT")
					   STIJL(0,0)
					   KLEUR(7)
					   )
				)				
			
;paal-verlichting (GRB-detail)
P02	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI102")
			KLEUR(30)
			)	
			
;paal-electriciteit (GRB-detail)
P03	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI103")
			KLEUR(30)
			)		

;paal-telefoon (GRB-detail)
P04	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI104")
			KLEUR(30)
			)

;paal-bovenleiding tram, trein of trolly (GRB-detail)
P05	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI105")
			KLEUR(30)
			)				

;paal-seininstallatie overgang spoorbedding NMBS (GRB-detail)
P06	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI106")
			KLEUR(30)
			)	

;paal-verkeerslicht (GRB-detail)
P07	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI107")
			KLEUR(30)
			)	
			
;paal-verkeerslicht overhangend(GRB-detail)
P08	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI108")
			KLEUR(30)
			)	

;paal-verkeerslicht voetganger/fietser(GRB-detail)
P09	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI109")
			KLEUR(30)
			)			
			
;paal-flitspaal (GRB-detail)
P10	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI110")
			KLEUR(30)
			)	


;paal-divers (GRB-detail)
P21	= PUNT(	
			LAAG("WPI1")
			STIJL("GRB","WPI111")
			KLEUR(30)
			)	

; kilometerpaal
P72 = PUNT      (
                LAAG("WPI7")
                STIJL("GRB","WPI702")
                KLEUR(232)
                )
                
; hectometerpaal
P73 = PUNT      (
                LAAG("WPI7")
                STIJL("GRB","WPI703")
                KLEUR(232)
                )
			
 ; waterslikker horizontaal 
P91 = PUNT_IN_POLYLIJN 
                (
                LAAG("WPI9")
                STIJL("GRB","WPI901")
                KLEUR(164)
                GROEP("WEGEN")
                )
                
; waterslikker verticaal
P92 = PUNT_IN_POLYLIJN 
                (
                LAAG("WPI9")
                STIJL("GRB","WPI902")
                KLEUR(164)
                GROEP("WEGEN")
                )			
			
; gesoleerde horizontale straatkolk
P93 = PUNT_IN_POLYLIJN 
                (
                LAAG("WPI9")
                STIJL("GRB","WPI903")
                KLEUR(164)
                GROEP("WEGEN")
                )				

; signalisatiepaal algemeen
P11 = PUNT(
			LAAG("WPI11")
			STIJL("GRB","WPI1101")
			KLEUR(21)
			)
                
; signalisatiepaal openbaar vervoer
P12 = PUNT(
			LAAG("WPI11")
			STIJL("GRB","WPI1102")
			KLEUR(21)
			)
			
; signalisatiepaal reflectorpaal
P13 = PUNT(
			LAAG("WPI11")
			STIJL("GRB","WPI1103")
			KLEUR(21)
			)	
			
; signalisatiepaal publiciteit
P14 = PUNT(
			LAAG("WPI12")
			STIJL("GRB","WPI1201")
			KLEUR(225)
			)				
			
; openbare brievenbus
P33 = PUNT      (
                LAAG("WPI13")
                STIJL("GRB","WPI1301")
                KLEUR(10)
                )			
			
			
; vaste wegmonoliet
P42 = PUNT(
			LAAG("WPI14")
			STIJL("GRB","WPI1402")
			KLEUR(252)
			)
		
; verzinkbare wegmonoliet
P43 = PUNT(
			LAAG("WPI14")
			STIJL("GRB","WPI1403")
			KLEUR(252)
			)		
; wegneembare wegmonoliet
P44 = PUNT(
			LAAG("WPI14")
			STIJL("GRB","WPI1404")
			KLEUR(252)
			)		
			
; omklapbare wegmonoliet
P45 = PUNT(
			LAAG("WPI14")
			STIJL("GRB","WPI1405")
			KLEUR(252)
			)				
			
; openbare vuilnisbak
P51 = PUNT      (
                LAAG("WPI15")
                STIJL("GRB","WPI1501")
                KLEUR(96)
                )			

; fietsstalling
P61 = PUNT(
			LAAG("WPI16")
			STIJL("GRB","WPI1601")
			KLEUR(147)
			)


; zichtbare straatkap gelijkgronds: water
SKW = PUNT      (
                LAAG("WPI17")
                STIJL("GRB","WPI1702")
                KLEUR(230)
				TEKST(
					LAAG("WRC1")
					GROOTTE(4)
					HORIZONTALE_ALIGNERING(MIDDEN)
					VERTIKALE_ALIGNERING(MIDDEN)
					INHOUD("%T")				;'D, R, W, V
					KLEUR(242)
					)
				
                )
                
; zichtbare straatkap gelijkgronds: gas
SKG = PUNT      (
                LAAG("WPI17")
                STIJL("GRB","WPI1703")
                KLEUR(230)
                )
                
; zichtbare straatkap gelijkgronds: electriciteit
SKE = PUNT      (
                LAAG("WPI17")
                STIJL("GRB","WPI1704")
                KLEUR(230)
                )
                
; zichtbare straatkap gelijkgronds: telecom
SKT = PUNT      (
                LAAG("WPI17")
                STIJL("GRB","WPI1705")
                KLEUR(230)
                )
                
; zichtbare straatkap gelijkgronds: brandkraan
SKB = PUNT      (
                LAAG("WPI17")
                STIJL("GRB","WPI1706")
                KLEUR(230)
                )
                
; zichtbare straatkap gelijkgronds: divers
SKD = PUNT      (
                LAAG("WPI17")
                STIJL("GRB","WPI1707")
                KLEUR(230)
                )


; zichtbare merkpaal: water
MPW = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1802")
                KLEUR(230)
                )

; zichtbare merkpaal: gas
MPG = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1803")
                KLEUR(230)
                )			
			
; zichtbare merkpaal: electriciteit
MPE = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1804")
                KLEUR(230)
                )			
				
; zichtbare merkpaal: telecom
MPT = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1805")
                KLEUR(230)
                )

; zichtbare merkpaal: brandkraan
MPB = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1806")
                KLEUR(230)
                )				
				
; zichtbare merkpaal: divers
MPD = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1807")
                KLEUR(230)
                )	

; zichtbare merkpaal: brandstof
MPS = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1808")
                KLEUR(230)
                )	

; zichtbare merkpaal: persleiding DWA/RWA
MPP = PUNT      (
                LAAG("WPI18")
                STIJL("GRB","WPI1809")
                KLEUR(230)
                )					
				
; particulier deksel
P19 = PUNT      (
                LAAG("WPI19")
                STIJL("GRB","WPI1901")
                KLEUR(155)
                )				

; lichtpunt
P20 = PUNT      (
                LAAG("WPI20")
                STIJL("GRB","WPI2001")
                KLEUR(40)
                )
				
; huisaansluiting DWA
HAD = PUNT      (
                LAAG("WPI22")
                STIJL("GRB","WPI2204")
                KLEUR(221)
                )	

; huisaansluiting RWA
HAR = PUNT      (
                LAAG("WPI22")
                STIJL("GRB","WPI2205")
                KLEUR(221)
                )	
				
; huisaansluiting verscheidene
HAV = PUNT      (
                LAAG("WPI22")
                STIJL("GRB","WPI2207")
                KLEUR(221)
                )	
				
; parkeermeter en automaat
P23 = PUNT      (
                LAAG("WPI23")
                STIJL("GRB","WPI2301")
                KLEUR(162)
                )				

; vlaggenpaal
P24 = PUNT      (
                LAAG("WPI24")
                STIJL("GRB","WPI2401")
                KLEUR(24)
                )


; openbare straatverlichting aan gevel/muur
P81 = PUNT      (
                LAAG("WPI31")
                STIJL("GRB","WPI3101")
                KLEUR(120)
                )
				
; cultuurhistorisch element (puntvormig)
P82 = PUNT      (
                LAAG("WPI32")
                STIJL("GRB","WPI3201")
                KLEUR(34)
                )	

; knipperlicht
P83 = PUNT      (
                LAAG("WPI33")
                STIJL("GRB","WPI3301")
                KLEUR(31)
                )					
					
				
;zichtbaar cirkelvormig putdeksel - DWA (detail)
R04 = PUNT(
                LAAG("WRI1")
                STIJL("GRB","WRI104")
                KLEUR(220)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")		;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )	

;zichtbaar cirkelvormig putdeksel - RWA (detail)
R05 = PUNT(
                LAAG("WRI1")
                STIJL("GRB","WRI105")
                KLEUR(220)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")		;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )	

;zichtbaar cirkelvormig putdeksel - eigendom (water)maatschappij (detail)
R06 = PUNT(
                LAAG("WRI1")
                STIJL("GRB","WRI106")
                KLEUR(220)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")		;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )				
				
;zichtbaar cirkelvormig putdeksel - verscheidene (geen opschrift, gemengd of opschrift DRWA) (detail)
R07 = PUNT(
                LAAG("WRI1")
                STIJL("GRB","WRI107")
                KLEUR(220)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")		;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )	

				
; zichtbare vierkant putdeksel - DWA(detail)
R24 = PUNT      (
                LAAG("WRI2")
                STIJL("GRB","WRI204")
                KLEUR(245)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")	;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )					
				
; zichtbare vierkant putdeksel - RWA(detail)
R25 = PUNT      (
                LAAG("WRI2")
                STIJL("GRB","WRI205")
                KLEUR(245)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")	;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )					

; zichtbaar vierkant putdeksel - eigendom (water)maatschappij(detail)
R26 = PUNT      (
                LAAG("WRI2")
                STIJL("GRB","WRI206")
                KLEUR(245)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")	;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )

; zichtbaar vierkant putdeksel - verscheidene (geen opschrift, gemengd of opschrift DRWA)
R27 = PUNT      (
                LAAG("WRI2")
                STIJL("GRB","WRI207")
                KLEUR(245)
				TEKST(
					LAAG("HOT")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(5)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%H")	;moet wel afgerond worden in cm! => voorkeuren moeten goed staan
					)	
                )

; overgang verharding
V10 = POLYLIJN  (
                LAAG("WRV10")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(8)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; rand bedekking
V11 = POLYLIJN  (
                LAAG("WRV11")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(32)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; rand verharding, binnenkant fietspad
V12 = POLYLIJN  (
                LAAG("WRV12")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(11)
                GROEP("FIETSPAD")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; rand verharding
V19 = POLYLIJN  (
                LAAG("WRV19")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(72)
                GROEP("WEGRAND")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				

; rand verharding, binnenkant straatgoot
V20 = POLYLIJN  (
                LAAG("WRV20")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(162)
                GROEP("WEGRANDGOOT")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; binnenkant afwateringsrooster
V21 = POLYLIJN  (
                LAAG("WRV21")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(37)
                GROEP("AFWATERING")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; Slagboom
WS1 = PUNT      (
                LAAG("WSB")
                STIJL("GRB","WSB01")
                KLEUR(242)
                )	

; Slagboom
WSB = POLYLIJN(
                LAAG("WSB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(242)
                GROEP("WSB")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(242)
                        )
                )
			
								
; inwendig verlichte signalisatie
WSM = PUNT(
			LAAG("WSM1")
			STIJL("GRB","WSM101")
			KLEUR(30)
			)


; inwendig verlichte signalisatie
SM1 = POLYLIJN  (
                LAAG("WSM1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(30)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; signalisatie- en leidingenportiek
SM2 = POLYLIJN  ( 
				LAAG("WSM2")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(53)
                GROEP("DIVERSE")
				PUNT(
						LAAG("ZPT")
						STIJL(0,0)
						KLEUR(7)
						)
				)
               
; niet-verplaatsbare zitbank
SM3 = POLYLIJN  (
                LAAG("WSM3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(244)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; tweevoetige mast
SM4 = POLYLIJN  (
                LAAG("WSM4")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(47)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; scharnierpunt hek/poort
WSP = PUNT      (
                LAAG("WSP")
                STIJL("GRB","WSP01")
                KLEUR(233)
                )				

				
; soort verharding/bedekking KWS
S01 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV101")
                KLEUR(7)
                )
                
; soort verharding/bedekking open KWS
S02 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV102")
                KLEUR(7)
                )
                
; soort verharding/bedekking cementbeton
S03 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV103")
                KLEUR(7)
                )
                
; soort verharding/bedekking kasseien
S04 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV104")
                KLEUR(7)
                )
                
; soort verharding/bedekking natuursteen
S05 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV105")
                KLEUR(7)
                )
                
; soort verharding/bedekking betonstraatstenen
S06 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV106")
                KLEUR(7)
                )
                
; soort verharding/bedekking betontegels
S07 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV107")
                KLEUR(7)
                )
                
; soort verharding/bedekking steenslag
S08 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV108")
                KLEUR(7)
                )
                
; soort verharding/bedekking dolomietsteenslag
S09 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV109")
                KLEUR(7)
                )

; soort verharding/bedekking gebakken straatstenen
S10 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV110")
                KLEUR(7)
                )
				
; soort verharding/bedekking gemozaek algemeen
S11 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV111")
                KLEUR(7)
                )				

; soort verharding/bedekking mozaekkeien
S12 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV112")
                KLEUR(7)
                )	

; soort verharding/bedekking gemozaek algemeen
S13 = PUNT      (
                LAAG("WSV1")
                STIJL("GRB","WSV113")
                KLEUR(7)
                )	

; soort bodembedekking: onverhard en niet begroeid
SN = PUNT      (
                LAAG("WSV10")
                STIJL("GRB","WSV1001")
                KLEUR(62)
                )
                
; soort bodembedekking: begroeid, gras
SB = PUNT      (
                LAAG("WSV10")
                STIJL("GRB","WSV1002")
                KLEUR(62)
                )		

; soort bodembedekking: grasdal
SG = PUNT      (
                LAAG("WSV10")
                STIJL("GRB","WSV1003")
                KLEUR(62)
                )	

; teen verharde talud
TO1 = POLYLIJN  (
                LAAG("WTO1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(254)
                GROEP("TALUDTEEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; kruin verharde talud
TO2 = POLYLIJN  (
                LAAG("WTO2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(251)
                GROEP("TALUDKRUIN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; teen onverharde talud
TO3 = POLYLIJN  (
                LAAG("WTO3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(54)
                GROEP("TALUDTEEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; kruin onverharde talud
TO4 = POLYLIJN  (
                LAAG("WTO4")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(94)
                GROEP("TALUDKRUIN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; waterput
WTP = POLYLIJN  (
                LAAG("WTP")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(122)
                GROEP("WTP")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )

; waterput
WP1 = PUNT      (
                LAAG("WTP")
                STIJL("GRB","WTP01")
                KLEUR(122)
                )

;verkeersgeleider				
VG1 = PUNT (
                LAAG("WVG")
                STIJL("GRB","WVG01")
                KLEUR(50)
                )	
;============================================================================
;  groen- en begraafplaatsen
;============================================================================	

; gebouwaanhorigheid type verdieping
BP# = POLYLIJN  (
                LAAG("BPF")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(18)
                GROEP("bpf#")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; grafrand
BG1 = POLYLIJN  (
                LAAG("BPG1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(26)
                GROEP("GRAVEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; rand grafkelder
BG2 = POLYLIJN  (
                LAAG("BPG2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(33)
                GROEP("GRAVEN")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				


;nummer sectie
BP1 = TEKST(
				LAAG("BPN1")
				GROOTTE(11)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(242)
				)

;nummer sectie
BP1 = TEKST(
				LAAG("BPN1")
				GROOTTE(11)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(242)
				)

;grafnummer
BP2 = TEKST(
				LAAG("BPN2")
				GROOTTE(11)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(172)
				)


; groenafvalzone
BOS = POLYLIJN  (
                LAAG("BOS")
                STIJL(0,0)BREEDTE(1)
                KLEUR(112)
                GROEP("BOS")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; columbarium
BU1 = POLYLIJN  (
                LAAG("BPU1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(195)
                GROEP("GRAVEN2")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; urnenveld
BU2 = POLYLIJN  (
                LAAG("BPU2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(150)
                GROEP("GRAVEN3")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; groenafvalzone
BPZ = POLYLIJN  (
                LAAG("BPZ")
                STIJL(0,0)BREEDTE(1)
                KLEUR(112)
                GROEP("ZONES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; 
MV1 = PUNT  (
                LAAG("MVK")
				STIJL("GRB","MVK01")
                STIJL(0,0)
             
                KLEUR(112)
                )

		
; 
MV2 = PUNT  (
                LAAG("MVK")
				STIJL("GRB","MVK02")
                STIJL(0,0)
                KLEUR(112)
                )

		
; park- en recreatieattributen
PR = PUNT      (
                LAAG("PRA")
                STIJL("GRB","PRA01")
                KLEUR(244)
				TEKST (
					LAAG("PRC")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(7)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%T")
					)
                )

; park- en recreatieattributen
PRA = POLYLIJN  (
                LAAG("PRA")
                STIJL(0,0)BREEDTE(1)
                KLEUR(244)
                GROEP("PRA")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
				TEKST (
					LAAG("PRC")
					HORIZONTALE_ALIGNERING(MIDDEN) 
					VERTIKALE_ALIGNERING(MIDDEN)
					GROOTTE(7)
					KLEUR(7)
					POSITIE(0,0)
					INHOUD("%T")
					)						
                )

; Boombeugel
WGB = POLYLIJN      (
                LAAG("WGB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(111)
                GROEP("WGB")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(111)
                        )
                )	

; individuele struik
WI4 = PUNT      (
                LAAG("WGI4")
                STIJL("GRB","WGI401")
                KLEUR(94)
                )
	

; groenzone
WI6 = POLYLIJN  ( 
				LAAG("WGI6")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(3)
                GROEP("DIVERSE")
				PUNT(     
					LAAG("ZPT")
					STIJL(0,0)
					KLEUR(7)
					)
                )

; hoogte haag
WI9 = TEKST (
				LAAG("WGI9")
				HORIZONTALE_ALIGNERING(MIDDEN) 
				VERTIKALE_ALIGNERING(MIDDEN)
				GROOTTE(7)
				KLEUR(80)
				INHOUD("%T")
				)	

; kruin van een boom
WI0 = POLYLIJN  (  
				LAAG("WGI10")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(90)
                GROEP("DIVERSE")
				PUNT(
				   LAAG("ZPT")
				   STIJL(0,0)
				   KLEUR(7)
				   )
				)


; leibomen
W1L = POLYLIJN  (
                LAAG("WGI11")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(54)
                GROEP("DIVERSE")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )
				
; leibomen
W1P = PUNT(
			LAAG("WGI11")
			STIJL("GRB","WGI1101")
			KLEUR(54)
			)


; waterpunt
WPT = PUNT      (
                LAAG("WPT")
                STIJL("GRB","WPT01")
                KLEUR(170)
                )




; soort bedekking schors
SVS = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1101")
                KLEUR(34)
				)
				
; soort bedekking mlsh
SVM = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1102")
                KLEUR(34)
                )
				
; soort bedekking rubberen matten of tegels
SVR = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1103")
                KLEUR(34)
                )

; soort bedekking gravel
SVG = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1104")
                KLEUR(34)
                )
				
; soort bedekking grond
SVO = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1105")
                KLEUR(34)
                )	

; soort bedekking kunstgras
SVK = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1106")
                KLEUR(34)
                )				
				
; soort bedekking schelpen
SVC = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1107")
                KLEUR(34)
                )		

; soort bedekking ternair mengsel
SVE = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1108")
                KLEUR(34)
                )					
				
; soort bedekking zand
SVZ = PUNT      (
                LAAG("WSV11")
                STIJL("GRB","WSV1109")
                KLEUR(34)
                )						

;============================================================================
;  water- en rioolbeheer
;============================================================================	

; bijzondere hydraulische constructie
K20 = POLYLIJN  (
                LAAG("KNW20")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(187)
                GROEP("CONSTRUCTIES")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; steiger
K2 = PUNT      (
                LAAG("KNW21")
                STIJL("GRB","KNW2101")
                KLEUR(32)
                )
				
; steiger
K21 = POLYLIJN  (
                LAAG("KNW21")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(32)
                GROEP("KNW21")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				
				
				
; steiger
WGK = PUNT      (
                LAAG("WGK")
                STIJL("GRB","WGK01")
                KLEUR(5)
                )	

;tekstcode voor spoorbaan en terrein
WNM = TEKST(
				LAAG("WNM")
				GROOTTE(13)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(5)
				)	

; peilbuis
WPB = PUNT (
                LAAG("WPB")
                STIJL("GRB","WPB01")
                KLEUR(211)
                )
				

; boei of baak
P25 = PUNT      (
                LAAG("WPI25")
                STIJL("GRB","WPI2501")
                KLEUR(14)
                )
                
; ladder
P26 = PUNT      (
                LAAG("WPI26")
                STIJL("GRB","WPI2601")
                KLEUR(44)
                )
; reddingsboei
P27 = PUNT      (
               LAAG("WPI27")
                STIJL("GRB","WPI2701")
                KLEUR(45)
                )
				
; meerpaal (in het water)
P34 = PUNT      (
               LAAG("WPI34")
                STIJL("GRB","WPI3401")
                KLEUR(36)
                )				

; geleidingspaal
P35 = PUNT      (
               LAAG("WPI345")
                STIJL("GRB","WPI3501")
                KLEUR(250)
                )

; aanlegplaats veerpont
WRA = PUNT      (
                LAAG("WRA")
                STIJL("GRB","WRA01")
                KLEUR(124)
                )
				
; waterpeilcode
WC6 = PUNT      (
                LAAG("WRC6")
                STIJL("GRB","WRC601")
                KLEUR(7)
				TEKST(
					GROOTTE(7)
					HORIZONTALE_ALIGNERING(MIDDEN)
					VERTIKALE_ALIGNERING(MIDDEN)
					INHOUD("%T")
					)	
                )

				
; fender
WRF = PUNT      (
                LAAG("WRF")
                STIJL("GRB","WRF01")
                KLEUR(205)
                )			
				
; peilschaal
RM1 = PUNT      (
                LAAG("WRM1")
                STIJL("GRB","WRM101")
                KLEUR(224)
                )
                
; limnigraaf
RM2 = PUNT      (
                LAAG("WRM2")
                STIJL("GRB","WRM201")
                KLEUR(204)
                )
                
; debietmeter
RM3 = PUNT      (
                LAAG("WRM3")
                STIJL("GRB","WRM301")
                KLEUR(212)
                )


               
; oeververharding schanskorven
WR1 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO01")
                KLEUR(196)
                )
                
; oeververharding steenstorting
WR2 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO02")
                KLEUR(196)
                )
                
; oeververharding prefab element
WR3 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO03")
                KLEUR(196)
                )
                
; oeververharding beton
WR4 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO04")
                KLEUR(196)
                )
                
; oeververharding metselwerk
WR5 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO05")
                KLEUR(196)
                )
                
; oeververharding erosiewerend weefsel
WR6 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO06")
                KLEUR(196)
                )
                
; oeververharding gefixeerde steenbestorting
WR7 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO07")
                KLEUR(196)
                )
                
; oeververharding houtmatten
WR8 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO08")
                KLEUR(196)
                )
                
; oeververharding andere
WR9 = PUNT      (
                LAAG("WRO")
                STIJL("GRB","WRO09")
                KLEUR(196)
                )

; rioolpijp (hoofdriolering)
RP1 = POLYLIJN  (
                LAAG("WRP1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(250)
                GROEP("RIOLERING")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
				TEKST(
						LAAG("WRC5")
						HORIZONTALE_ALIGNERING(MIDDEN) 
						VERTIKALE_ALIGNERING(MIDDEN)
						GROOTTE(5)
						POSITIE(0,0)
						KLEUR(250)
						INHOUD("x m -  x - x mm/m - B")
						)
                )	

; rioolpijp (aansluiting)
RP2 = POLYLIJN  (
                LAAG("WRP2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(172)
                GROEP("RIOLERING")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
				TEKST(
						LAAG("WRC5")
						HORIZONTALE_ALIGNERING(MIDDEN) 
						VERTIKALE_ALIGNERING(MIDDEN)
						GROOTTE(5)
						POSITIE(0,0)
						KLEUR(250)
						INHOUD("x m -  x - x mm/m - B")
						)	   
                )	


; rioolpijp (virtueel)
RP3 = POLYLIJN  (
                LAAG("WRP3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(172)
                GROEP("RIOLERING")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
				TEKST(
						LAAG("WRC5")
						HORIZONTALE_ALIGNERING(MIDDEN) 
						VERTIKALE_ALIGNERING(MIDDEN)
						GROOTTE(5)
						POSITIE(0,0)
						KLEUR(250)
						INHOUD("x m -  x - x mm/m - B")
						)	   
                )	
                
; signalisatiebord scheepvaart elektrisch
RS1 = PUNT      (
                LAAG("WRS1")
                STIJL("GRB","WRS101")
                KLEUR(30)
                )
                
; signalisatiebord scheepvaart niet-elektrisch
RS2 = PUNT      (
                LAAG("WRS2")
                STIJL("GRB","WRS201")
                KLEUR(22)
                )				

; riooltoegang normale toegang
RT1 = PUNT_IN_POLYLIJN 
                (
                LAAG("WRT")
                STIJL("GRB","WRT01")
                KLEUR(240)
                GROEP("RIOOLTOEGANG")
                )
                
; riooltoegang rooster
RT2 = PUNT_IN_POLYLIJN 
                (
                LAAG("WRT")
                STIJL("GRB","WRT02")
                KLEUR(240)
                GROEP("RIOOLTOEGANG")
                )
                
; riooltoegang terugslagklep
RT3 = PUNT_IN_POLYLIJN 
                (
                LAAG("WRT")
                STIJL("GRB","WRT03")
                KLEUR(240)
                GROEP("RIOOLTOEGANG")
                )

; dukdalf
WRU = POLYLIJN  (
                LAAG("WRU")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(62)
                GROEP("RIOLERING")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
					)
				)

; kesp
RW1 = POLYLIJN  (
                LAAG("WRW1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(182)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; damplanken
RW2 = POLYLIJN  (
                LAAG("WRW2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(132)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; betuining
RW3 = POLYLIJN  (
                LAAG("WRW3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(54)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; waterlijn
RW4 = POLYLIJN  (
                LAAG("WRW4")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(152)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; palen bordage
RW5 = POLYLIJN  (
                LAAG("WRW5")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(128)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; waterkeermuur
RW6 = POLYLIJN  ( 
				LAAG("WRW6")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(242)
                GROEP("DIVERSE")
                PUNT(
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )

; combiwand
RW7 = POLYLIJN  ( 
				LAAG("WRW7")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(27)
                GROEP("DIVERSE")
                PUNT(
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )				

; inrichting kustbescherming
RW8 = POLYLIJN  ( 
				LAAG("WRW8")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(34)
                GROEP("DIVERSE")
                PUNT(
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )	

; stroomrichting
WTS = PUNT      (
                LAAG("WTS")
                STIJL("GRB","WTS01")
                KLEUR(168)
                )

;============================================================================
;  wegbeheer
;============================================================================	

THO = TEKST  (
				LAAG("THO")
				GROOTTE(5)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				KLEUR(7)
				INHOUD("%T")
				SCHUINE_TEKST
				)

; gebouwaanhorigheid type kelderraam
GB9 = PUNT_IN_POLYLIJN      
                (
                LAAG("GBA9")
                STIJL("GRB","GBA901")
                KLEUR(161)
                GROEP("GB9")
                PROJECTIE
                )

; referentiepunt zetting
RF3 = PUNT      (
                LAAG("REF3")
                STIJL("GRB","REF301")
                KLEUR(30)
                )

; brugvoeg
WBV = POLYLIJN  ( 
				LAAG("WBV")
				STIJL(0,0)
				BREEDTE(1)
				KLEUR(150)
                GROEP("WBV")
                PUNT(
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )
				
; functiecode wegdeel: aanliggend gelijkgronds fietspad
D01 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC01")
                KLEUR(109)
                )
				
; functiecode wegdeel: aanliggend verhoogd fietspad
D02 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC02")
                KLEUR(109)
                )				

; functiecode wegdeel: eigen bedding tram/bus
D03 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC03")
                KLEUR(109)
                )
				
; functiecode wegdeel: bushaltehaven
D04 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC04")
                KLEUR(109)
                )	
				
; functiecode wegdeel: busstrook
D05 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC05")
                KLEUR(109)
                )	

; functiecode wegdeel: middenberm
D06 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC06")
                KLEUR(109)
                )	
				
; functiecode wegdeel: oprit
D07 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC07")
                KLEUR(109)
                )

; functiecode wegdeel: parkeervlak
D08 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC08")
                KLEUR(109)
                )	

; functiecode wegdeel: pechstrook
D09 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC09")
                KLEUR(109)
                )	

; functiecode wegdeel: rijbaan
D10 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC10")
                KLEUR(109)
                )	

; functiecode wegdeel: tussenberm
D11 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC11")
                KLEUR(109)
                )	

; functiecode wegdeel: voetgangsergebied
D12 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC12")
                KLEUR(109)
                )

; functiecode wegdeel: voetpad
D13 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC13")
                KLEUR(109)
                )

; functiecode wegdeel: voetweg of pad
D14 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC14")
                KLEUR(109)
                )
				
; functiecode wegdeel: vrijliggend fietspad
D15 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC15")
                KLEUR(109)
                )				

; functiecode wegdeel: zijberm
D16 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC16")
                KLEUR(109)
                )

; functiecode wegdeel: zijberm
D17 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC17")
                KLEUR(109)
                )

; functiecode wegdeel: zijberm
D18 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC18")
                KLEUR(109)
                )

; functiecode wegdeel: zijberm
D19 = PUNT      (
                LAAG("WDC")
                STIJL("GRB","WDC19")
                KLEUR(109)
                )		


;
MVP = POLYLIJN(
                LAAG("MVP")
                STIJL(0,0)
                BREEDTE(1)
                GROEP("WDL")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(232)
                        )
                )


;
OBB = POLYLIJN(
                LAAG("OBB")
                STIJL(0,0)
                BREEDTE(1)
                GROEP("WDL")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(232)
                        )
                )

; Detectielus
WDL = POLYLIJN(
                LAAG("WDL")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(232)
                GROEP("WDL")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(232)
                        )
                )

; Wegdekreflector
WDR = POLYLIJN      (
                LAAG("WDR")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(230)
                GROEP("WDR")
                PUNT(
                        LAAG("ZPT")
                        STIJL("GRB","WDR01")
                        KLEUR(230)
                        )
                )


                
; puntvormige wegmarkering fiets
W01 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM101")
                KLEUR(55)
                )
                
; puntvormige wegmarkering mindervalide
W02 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM102")
                KLEUR(55)
                )
                
; puntvormige wegmarkering snelheidsbeperking 30 km/h
W03 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM103")
                KLEUR(55)
                )
                
; puntvormige wegmarkering snelheidsbeperking 50 km/h
W04 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM104")
                KLEUR(55)
                )
                
; puntvormige wegmarkering parkeerverbod
W05 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM105")
                KLEUR(55)
                )
                
; puntvormige wegmarkering plaats met veel kinderen
W06 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM106")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl rechts- en linksaf
W07 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM107")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl linksaf
W08 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM108")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl rechtsaf
W09 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM109")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl rechtsaf, linksaf en rechtdoor
W10 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM110")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl rechtdoor
W11 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM111")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl rechtdoor en linksaf
W12 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM112")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl rechtdoor en rechtsaf
W13 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM113")
                KLEUR(55)
                )
                
; puntvormige wegmarkering rijstrooksverminderingspijlen
W14 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM114")
                KLEUR(55)
                )
                
; puntvormige wegmarkering pijl op fietspad
W15 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM115")
                KLEUR(55)
                )
                
; puntvormige wegmarkering uitroepteken
W16 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM116")
                KLEUR(55)
                )
                
; puntvormige wegmarkering voorrangsteken
W17 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM117")
                KLEUR(55)
                )

; puntvormige wegmarkering: pijl linksaf type 2
W18 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM118")
                KLEUR(55)
                )                

; puntvormige wegmarkering: pijl rechtsaf type 2
W19 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM119")
                KLEUR(55)
                )  

; puntvormige wegmarkering: pijl linksaf type 3
W20 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM120")
                KLEUR(55)
                ) 

; puntvormige wegmarkering: pijl rechtsaf type 3
W21 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM121")
                KLEUR(55)
                ) 

; puntvormige wegmarkering: rijstrookverminderingspijl rechts
W22 = PUNT      (
                LAAG("WEM1")
                STIJL("GRB","WEM122")
                KLEUR(55)
                ) 


; lijnvormige wegmarkering
WE2 = POLYLIJN  (
                LAAG("WEM2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(63)
                GROEP("WE2")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; vlakvormige wegmarkering
W31 = POLYLIJN  (
                LAAG("WEM3")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(130)
                GROEP("W31")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; vlakvormige wegmarkering: verkeersgeleiders
M31 = PUNT(
			LAAG("WEM3")
			STIJL("GRB","WEM301")
			KLEUR(130)
			)				
	
; vlakvormige wegmarkering: verdrijvingsvlakken
M32 = PUNT(
			LAAG("WEM3")
			STIJL("GRB","WEM302")
			KLEUR(130)
			)						
				
                
; vlakvormige wegmarkering: zebrapad
M33 = PUNT(
			LAAG("WEM3")
			STIJL("GRB","WEM303")
			KLEUR(130)
			)

; vlakvormige wegmarkering: fietssuggestiestrook
M34 = PUNT(
			LAAG("WEM3")
			STIJL("GRB","WEM304")
			KLEUR(130)
			)

; geluidsscherm
WGS = POLYLIJN  (
                LAAG("WGS")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(134)
                GROEP("WGS")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; heipaal
HP1 = PUNT(
			LAAG("WEM3")
			STIJL("GRB","WHP01")
			KLEUR(36)
			)

; hoogtecode muren
WC1 = POLYLIJN  (
                LAAG("WIC1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(12)
                GROEP("WC1")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; hoogtecode muren
WKH = POLYLIJN  (
                LAAG("WKH")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(202)
                GROEP("WKH")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )		

; kamlijn weg
WKL = POLYLIJN  (
                LAAG("WKL")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(95)
                GROEP("WKL")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; landhoofd
WLH = POLYLIJN  (
                LAAG("WLH")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(90)
                GROEP("WLH")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; nutsvoorzieningscode
WNC = POLYLIJN  (
                LAAG("WNC")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(160)
                GROEP("WNC")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )


; vangrail steunpalen
W36 = PUNT(
			LAAG("WPI36")
			STIJL("GRB","WPI3601")
			KLEUR(210)
			)

; zettingsbaak
WM4 = PUNT(
			LAAG("WRM4")
			STIJL("GRB","WRM401")
			KLEUR(181)
			)

; kabelgoot/afleggoot
RV2 = POLYLIJN(
                LAAG("WRV22")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(120)
                GROEP("WRV22")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; blindengeleidingstegels
SV8 = PUNT      (
                LAAG("WSV8")
                STIJL("GRB","WSV801")
                KLEUR(32)
                )

; tunnelrand of koker
WTK = POLYLIJN(
                LAAG("WTK")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(195)
                GROEP("WTK")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; vrije onderdoorgang
WVO = PUNT (
			LAAG("WVO")
			STIJL("GRB","WVO01")
			KLEUR(1)
			TEKST  (
					LAAG("THO")
					GROOTTE(5)
					HORIZONTALE_ALIGNERING(MIDDEN)
					VERTIKALE_ALIGNERING(MIDDEN)
					KLEUR(7)
					INHOUD("%T")
					SCHUINE_TEKST
					POSITIE(0, 0)
					)
            )

; Weegbrug
WWB = POLYLIJN      (
                LAAG("WWB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(29)
                GROEP("WWB")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )	

;============================================================================
;  virtuele grenzen
;============================================================================	

; puntnummer en tekst grens volgens Atlas der Buurtwegen
TAB = POLYLIJN      (
                LAAG("TAB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(46)
                GROEP("TAB")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )	

; puntnummer en tekst grens volgens Atlas der onbevaarbare waterlopen
TA1 = POLYLIJN      (
                LAAG("TAW1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(142)
                GROEP("TAW1")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; puntnummer en tekst grens der bevaarbare waterlopen
TA2 = POLYLIJN      (
                LAAG("TAW2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(150)
                GROEP("TAW2")
                PUNT(  
                      LAAG("ZPT")
                      STIJL(0,0)
                      KLEUR(7)
                      )
                )

; Tabel met cordinaten
TBC = POLYLIJN  (
                LAAG("TBC")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(7)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
				
;tekst bouwlijn
TBL = TEKST(
				LAAG("TBL")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(11)
				)

; Tabel met bochtparameters
TBP = POLYLIJN  (
                LAAG("TBP")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(7)
                GROEP("DIVERSE")
                PUNT( 
                       LAAG("ZPT")
                       STIJL(0,0)
                       KLEUR(7)
                       )
                )				

;tekst grens erfdienstbaarheid
TED = TEKST(
				LAAG("TED")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(9)
				)

;tekst grens erfdienstbaarheid
TEG = TEKST(
				LAAG("TEG")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(7)
				)

;tekst grens erfdienstbaarheid
TGG = TEKST(
				LAAG("TGG")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(31)
				)

;tekst grondinname- en/of -afstoot
TGI = TEKST(
				LAAG("TGI")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(7)
				)

;puntnummer en tekst grens zone grondoverschot
TGO = TEKST(
				LAAG("TGO")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(220)
				)

;kadastrale identificatie
TKG = TEKST(
				LAAG("TKG")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(37)
				)

;puntnummer en tekst grens zone ondergrondse inneming
TOI = TEKST(
				LAAG("TOI")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(191)
				)

;puntnummer en tekst grens onteigeningszone
TOZ = TEKST(
				LAAG("TOZ")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(214)
				)

;tekst rijksgrens
TRG = TEKST(
				LAAG("TRG")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(41)
				)	


;puntnummer en tekst indicatieve rooilijn
TR1 = TEKST(
				LAAG("TRL1")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(1)
				)

;puntnummer en tekst indicatieve rooilijn
TR2 = TEKST(
				LAAG("TRL2")
				GROOTTE(9)
				HORIZONTALE_ALIGNERING(MIDDEN)
				VERTIKALE_ALIGNERING(MIDDEN)
				INHOUD("%T")
				KLEUR(30)
				)

; grens volgens de Atlas der Buurtwegen
VAB = POLYLIJN  (
                LAAG("VAB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(46)
                GROEP("VAB")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; grens volgens de Atlas der onbevaarbare waterlopen
VA1 = POLYLIJN  (
                LAAG("VAW1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(142)
                GROEP("VA1")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; grens der bevaarbare waterlopen
VA2 = POLYLIJN  (
                LAAG("VAW2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(150)
                GROEP("VA2")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; bouwlijn
VBL = POLYLIJN  (
                LAAG("VBL")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(11)
                GROEP("VBL")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; grens erfdienstbaarheid
VED = POLYLIJN  (
                LAAG("VED")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(9)
                GROEP("VED")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; eigendomsgrens
VEG = POLYLIJN  (
                LAAG("VEG")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(7)
                GROEP("VEG")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; grens gemeente
VGG = POLYLIJN  (
                LAAG("VGG")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(31)
                GROEP("VGG")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; grens zone grondoverschot
VGO = POLYLIJN  (
                LAAG("VGO")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(220)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; grens Kadastrale afdeling en sectie
VKG = POLYLIJN  (
                LAAG("VKG")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(37)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

;Kadastrale eigendomsgrens
VOD = POLYLIJN      (
                LAAG("VOD")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(7)
                GROEP("VOD")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; grens zone ondergrondse inneming
VOI = POLYLIJN  (
                LAAG("VOI")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(191)
                GROEP("VOI")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; grens onteigeningszone
VOZ = POLYLIJN  (
                LAAG("VOZ")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(214)
                GROEP("VOZ")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; rijksgrens
VRG = POLYLIJN  (
                LAAG("VRG")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(41)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; indicatieve rooilijn
VR1 = POLYLIJN  (
                LAAG("VRL1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(1)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )
                
; goedgekeurde rooilijn
VR2 = POLYLIJN  (
                LAAG("VRL2")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(30)
                GROEP("DIVERSE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

;============================================================================
;  aanvullende steekkaarten
;============================================================================	

;
BBR = POLYLIJN(
                LAAG("BBR")
                STIJL(0,0)
		KLEUR(6)
                BREEDTE(1)
                GROEP("BBR")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(6)
                        )
                )

; cultuurgrens
CTG = POLYLIJN  (
                LAAG("CTG")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(46)
				GROEP("CTG")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; compensatie-as
EB1 = POLYLIJN  (
                LAAG("EBL1")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(4)
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

;naam cabine
EB2 = TEKST(
			INHOUD("CABINE %T")
			LAAG("EBL2")
			GROOTTE(11)
			HORIZONTALE_ALIGNERING(MIDDEN)
			VERTIKALE_ALIGNERING(MIDDEN)
			KLEUR(1)
			)	

; symbool cabine
EB3 = PUNT      (
                LAAG("EBL3")
                STIJL("GRB","EBL301")
                KLEUR(1)
                )

; constructie
EB5 = POLYLIJN  (
                LAAG("EBL5")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(42)
                GROEP("EBL5")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

EDU = POLYLIJN(
                LAAG("EDU")
                STIJL(0,0)
		KLEUR(169)
                BREEDTE(1)
                GROEP("EDU")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(169)
                        )
                )

EKO = POLYLIJN(
                LAAG("EKO")
                STIJL(0,0)
		KLEUR(13)
                BREEDTE(1)
                GROEP("EKO")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(13)
                        )
                )

; balkon of erker
G12 = POLYLIJN  (
                LAAG("GBA12")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(38)
                GROEP("GBA12")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

GKW = POLYLIJN(
                LAAG("GKW")
                STIJL(0,0)
		KLEUR(17)
                BREEDTE(1)
                GROEP("GKW")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(17)
                        )
                )



; meetkundig referentiepunt van het altimetrisch geodetisch net
MKA = PUNT      (
                LAAG("MKA")
                STIJL("GRB","MKA01")
                KLEUR(8)
                )
                
; meetkundig referentiepunt van het planimetrisch geodetisch net
MKP = PUNT      (
                LAAG("MKP")
                STIJL("GRB","MKP01")
                KLEUR(8)
                )

OER = POLYLIJN  (
                LAAG("OER")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(39)
                GROEP("OER")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )				

; radar
RAD = PUNT      (
                LAAG("RAD")
                STIJL("GRB","RAD01")
                KLEUR(50)
                )	

; Stootblok
SBK = POLYLIJN(
                LAAG("SBK")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(222)
                GROEP("SBK")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

SN2 = TEKST(
			INHOUD("%T" )	
			LAAG("SNM2")
			GROOTTE(14)
			HORIZONTALE_ALIGNERING(MIDDEN)
			VERTIKALE_ALIGNERING(MIDDEN)
			KLEUR(1)
			)

; Wisselbediening
SWB = PUNT      (
                LAAG("SWB")
                STIJL("GRB","SWB01")
                KLEUR(51)
                )

;typecode afsluiting
TCA = TEKST (
            LAAG("TCA")
            GROOTTE(11)
            HORIZONTALE_ALIGNERING(MIDDEN)
            VERTIKALE_ALIGNERING(MIDDEN)
            KLEUR(80)
            INHOUD("%T")
            SCHUINE_TEKST
            ) 

TKW = POLYLIJN(
                LAAG("TKW")
                STIJL(0,0)
		KLEUR(19)
                BREEDTE(1)
                GROEP("TKW")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(19)
                        )
                )

;vrije tekst
TVR = TEKST(
			INHOUD("%T")
			LAAG("TVR")
			GROOTTE(11)
			HORIZONTALE_ALIGNERING(MIDDEN)
			VERTIKALE_ALIGNERING(MIDDEN)
			KLEUR(255)
			)

;
VDG = PUNT      (
                LAAG("VDG")
                STIJL("GRB","VDG01")
                KLEUR(86)
                )

VOE = POLYLIJN  (
                LAAG("VOE")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(48)
                GROEP("VOE")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; laad en losinstallatie
WLL = POLYLIJN(
                LAAG("WLL")
                BREEDTE(1)
                KLEUR(64)
                GROEP("WLL")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; meteopaal
P28 = PUNT      (
                LAAG("WPI28")
                STIJL("GRB","WPI2801")
                KLEUR(113)
                )

; kleine windturbine
P29 = PUNT (
           LAAG("WPI29")
           STIJL("GRB","WPI2901")
           KLEUR(252)
           )		

;
PCT = PUNT      (
                LAAG("PCT")
                STIJL("GRB","PCT01")
                KLEUR(8)
                )

; regenpijp (afvoerpijp)
W30 = PUNT (
           LAAG("WPI30")
           STIJL("GRB","WPI3001")
           KLEUR(190)
           )

; regenpijp (afvoerpijp)
W37 = PUNT (
           LAAG("WPI37")
           STIJL("GRB","WPI3701")
           KLEUR(88)
           )

W38 = PUNT (
           LAAG("WPI38")
           STIJL("GRB","WPI3801")
           KLEUR(52)
           )

; geconstrueerde rand van de rijbaan
WB4 = POLYLIJN  (
                LAAG("WRB4")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(171)
                GROEP("WEGEN_WB4")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )

; rijbaankussen
WRK = POLYLIJN  (
                LAAG("WRK")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(85)
                GROEP("WRK")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(7)
                        )
                )


; sonderingspunt
W51 = PUNT (
           LAAG("WRM5")
           STIJL("GRB","WRM501")
           KLEUR(33)
           )

; camera
WS3 = PUNT (
           LAAG("WRS3")
           STIJL("GRB","WRS301")
           KLEUR(12)
           )

; transportband
WTB = POLYLIJN      (
                LAAG("WTB")
                STIJL(0,0)
                BREEDTE(1)
                KLEUR(64)
                GROEP("WTB")
                PUNT(
                        LAAG("ZPT")
                        STIJL(0,0)
                        KLEUR(64)
                        )
                )

WWD = PUNT (
           LAAG("WWD")
           STIJL("GRB","WWD01")
           KLEUR(51)
           )
			

